package ru.yandex.calendar.logic.mailer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.mailer.model.MailerMail;
import ru.yandex.calendar.logic.sending.real.MailHacks;
import ru.yandex.calendar.logic.sending.real.MailHeaders;
import ru.yandex.calendar.logic.sending.real.MailSenderUtils;
import ru.yandex.calendar.logic.user.UserOrMaillist;
import ru.yandex.commune.mail.MailMessage;

/**
 * @author dbrylev
 */
public class MailMessageUtils {

    private static final ListF<String> returnCopyHeaders = Cf.list(
            MailHeaders.DATE, MailHeaders.IN_REPLY_TO, MailHeaders.REFERENCES, MailHeaders.SUBJECT);

    private static final ListF<String> returnAddressHeaders = Cf.list(MailHeaders.FROM, MailHeaders.SENDER);

    public static MailMessage transformForReturn(UserOrMaillist user, MailMessage message, ActionInfo actionInfo) {
        MailMessage result = returnCopyHeaders.foldLeft(MailMessage.empty(),
                (acc, header) -> message.getHeader(header).map(h -> acc.addHeader(header, h)).getOrElse(acc));

        result = returnAddressHeaders.foldLeft(result,
                (acc, header) -> MailSenderUtils.parseAddressHeaderSafe(message, header)
                        .foldLeft(acc, (res, ad) -> res.addHeader(header, ad.toString())));

        result = MailHacks.addCalendarHeaders(result, actionInfo)
                .withHeader(MailHeaders.X_CALENDAR_NOT_FOR_EXCHANGE, "yes")
                .withMessageId(MailerMail.transformMessageId(message.getMessageId().getOrElse("no-message-id")));

        result = user.isUser()
                ? result.withTo(user.getEmail())
                : MailSenderUtils.withMaillistSharedFolderDestination(result, user.getEmail());

        return result.withContent(message.getContent());
    }
}
