package ru.yandex.calendar.logic.mailer;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;

import ru.yandex.calendar.logic.mailer.logbroker.MailAttachLogContextConfiguration;
import ru.yandex.calendar.util.PropertiesHolderUtils;

/**
 * @author dbrylev
 */
@Configuration
@Conditional(MailerContextLogbrokerConfiguration.Condition.class)
@Import(MailAttachLogContextConfiguration.class)
public class MailerContextLogbrokerConfiguration {

    static class Condition implements org.springframework.context.annotation.Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !PropertiesHolderUtils.getOrThrow("logbroker.client-id").isEmpty();
        }
    }

    @Bean
    public MailerUsers mailerUsers() {
        return new MailerUsers();
    }
}
