package ru.yandex.calendar.logic.mailer;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.MailerEvent;
import ru.yandex.calendar.logic.beans.generated.MailerEventFields;
import ru.yandex.calendar.logic.beans.generated.MailerEventHelper;
import ru.yandex.calendar.logic.mailer.model.MailerEventId;
import ru.yandex.calendar.logic.mailer.model.MailerGroup;
import ru.yandex.calendar.logic.mailer.model.MailerGroupId;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.calendar.util.db.DbUtils;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author dbrylev
 */
public class MailerEventDao extends CalendarJdbcDaoSupport {

    @Autowired
    private GenericBeanDao genericBeanDao;

    @RunWithRandomTest
    public void insert(ListF<MailerEvent> events) {
        genericBeanDao.insertBeans(events);
    }

    @RunWithRandomTest
    public void update(ListF<MailerEvent> events) {
        genericBeanDao.updateBeans(events);
    }

    @RunWithRandomTest
    public void delete(ListF<MailerEventId> eventIds) {
        genericBeanDao.deleteBeans(MailerEventHelper.INSTANCE, MailerEventId.inSet(eventIds));
    }

    @RunWithRandomTest
    public Option<MailerEvent> find(MailerEventId id) {
        return genericBeanDao.findBeanById(MailerEventHelper.INSTANCE, id.asTuple());
    }

    @RunWithRandomTest
    public Option<MailerEvent> findRepeatingMasterByIdSuffix(PassportUid uid, String suffix) {
        return genericBeanDao.findBean(MailerEventHelper.INSTANCE, SqlCondition.trueCondition()
                .and(MailerEventFields.UID.eq(uid))
                .and(MailerEventFields.RECURRENCE_ID.column().isNull())
                .and(MailerEventFields.REPETITION.column().isNotNull())
                .and(MailerEventFields.EXTERNAL_ID.op("LIKE", "%" + DbUtils.escapeForLike(suffix))));
    }

    @RunWithRandomTest
    public Option<MailerGroup> find(MailerGroupId id) {
        ListF<MailerEvent> events = genericBeanDao.loadBeans(MailerEventHelper.INSTANCE, id.eq());
        return Option.when(events.isNotEmpty(), () -> new MailerGroup(events));
    }
}
