package ru.yandex.calendar.logic.mailer;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.generated.MailerEvent;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.EventInvitationManager;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsMethod;
import ru.yandex.calendar.logic.mailer.change.MailerEventChange;
import ru.yandex.calendar.logic.mailer.change.MailerGroupChangesFinder;
import ru.yandex.calendar.logic.mailer.change.MailerGroupChangesInfo;
import ru.yandex.calendar.logic.mailer.model.FoundEvent;
import ru.yandex.calendar.logic.mailer.model.MailerAttendees;
import ru.yandex.calendar.logic.mailer.model.MailerGroup;
import ru.yandex.calendar.logic.mailer.model.MailerParticipant;
import ru.yandex.calendar.logic.user.SettingsInfo;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.dates.DateTimeManager;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author dbrylev
 */
public class MailerEventImporter {

    @Autowired
    private EventInvitationManager eventInvitationManager;
    @Autowired
    private SettingsRoutines settingsRoutines;
    @Autowired
    private MailerEventDao mailerEventDao;


    public IcsVTimeZones getTimezones(PassportUid uid, IcsCalendar calendar) {
        Option<SettingsInfo> settings = settingsRoutines.getSettingsByUidIfExists(uid);

        return IcsVTimeZones.cons(calendar.getTimezones(),
                settings.map(SettingsInfo::getTz).getOrElse(DateTimeManager.DEFAULT_TZ), true);
    }

    public MailerGroup convert(PassportUid uid, IcsCalendar calendar, ActionInfo actionInfo) {
        return MailerGroup.fromIcs(uid, calendar, getTimezones(uid, calendar),
                eventInvitationManager::getParticipantIdsByEmails, actionInfo.getNow());
    }

    public MailerGroupChangesInfo findChanges(PassportUid uid, IcsCalendar calendar, ActionInfo actionInfo) {

        MailerGroup their = convert(uid, calendar, actionInfo);

        Option<MailerGroup> ourO = mailerEventDao.find(their.getId());

        MailerGroupChangesInfo changes = MailerGroupChangesFinder.changes(
                ourO, their, calendar.getMethod().sameMethodAs(IcsMethod.CANCEL));

        if (!ourO.isPresent() && changes.getForMail().isCreated()) {

            changes = changes.withForMail(changes.getForMail().withPrevious(
                    StringUtils.notEmptyO(their.getId().getExternalId().split("_")[0])
                            .flatMapO(suffix -> mailerEventDao.findRepeatingMasterByIdSuffix(uid, suffix))));
        }
        return changes;
    }

    public MailerEventChange importIcs(
            PassportUid uid, IcsCalendar calendar, FoundEvent calendarEvent, ActionInfo actionInfo)
    {
        MailerGroupChangesInfo changes = findChanges(uid, calendar, actionInfo);

        if (changes.getForMail().isCreated()) {
            ListF<MailerParticipant> attendees = eventInvitationManager
                    .getParticipantsByEventId(calendarEvent.id.get().eventId)
                    .getAllAttendeesButNotOrganizerSafe().map(MailerParticipant::fromParticipant);

            Function<MailerEvent, MailerEvent> mergeF = e -> {
                MailerEvent ec = e.copy();

                ec.setAttendees(new MailerAttendees(
                        attendees.plus(ec.getAttendees().attendees).stableUniqueBy(MailerParticipant::getId)));

                return ec;
            };

            changes = changes.withCreate(changes.getCreate().map(mergeF))
                    .withForMail(changes.getForMail().withCurrent(changes.getForMail().getCurrent().map(mergeF)));
        }

        mailerEventDao.delete(changes.getDelete());
        mailerEventDao.update(changes.getUpdate());
        mailerEventDao.insert(changes.getCreate());

        return changes.getForMail();
    }
}
