package ru.yandex.calendar.logic.mailer;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import net.fortuna.ical4j.model.Property;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVEvent;
import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.log.LogEvent;
import ru.yandex.calendar.logic.log.LogEventType;
import ru.yandex.calendar.logic.mailer.model.MailerMail;
import ru.yandex.calendar.logic.user.UserOrMaillist;
import ru.yandex.commune.mail.HeaderNames;
import ru.yandex.commune.mail.MailMessage;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class MailerHandlingLogEventJson extends LogEvent {
    private final long mid;
    private final long uid;
    private final String email;
    private final Optional<String> messageDate;
    private final Optional<String> from;
    private final Optional<String> messageId;
    public final MailerHandlingResult.Status status;
    private final Optional<String> reason;
    private Optional<String> externalId;
    private Optional<Instant> recurrenceId;
    private Optional<String> icsMethod;

    public MailerHandlingLogEventJson(
            UserOrMaillist user, MailerMail mail, MailerHandlingResult result) {
        this.mid = mail.attach.mid;
        this.uid = user.uid.getUid();
        this.email = user.email.getEmail();
        this.messageDate = Optional.of(mail.date.toString());
        this.from = Optional.of(mail.sender.getEmail().getEmail());
        this.messageId = Optional.of(mail.messageId);
        this.status = result.status;
        this.reason = result.reason.toOptional();
        this.externalId = findExternalId(mail.ics);
        this.recurrenceId = findRecurrenceId(mail.ics);
        this.icsMethod = findIcsMethod(mail.ics);
    }

    public MailerHandlingLogEventJson(UserOrMaillist user, long mid, MailMessage message, MailerHandlingResult result) {
        this.mid = mid;
        this.uid = user.uid.getUid();
        this.email = user.email.getEmail();
        this.messageDate = message.getHeader(HeaderNames.DATE).toOptional();
        this.from = message.getHeader(HeaderNames.FROM).toOptional();
        this.messageId = message.getMessageId().toOptional();
        this.status = result.status;
        this.reason = result.reason.toOptional();

        this.externalId = Optional.empty();
        this.recurrenceId = Optional.empty();
        this.icsMethod = Optional.empty();
    }

    private Optional<String> findExternalId(IcsCalendar ics) {
        return ics.getEvents().filterMap(IcsVEvent::getUid).firstO().toOptional();
    }

    private Optional<Instant> findRecurrenceId(IcsCalendar ics) {
        return ics.getEventsGroupedByUidWithExpiredFiltered().firstO().filterMap(group -> group.getMasterOrFirstEvent().getRecurrenceIdInstantUtc()).firstO().toOptional();
    }

    private Optional<String> findIcsMethod(IcsCalendar ics) {
        return ics.getProperties(Property.METHOD).firstO().map(v -> v.getValue().toLowerCase()).toOptional();
    }

    @JsonGetter
    @Override
    public LogEventType type() {
        return LogEventType.MAILER_HANDLING;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public Optional<EventIdLogDataJson> getEventId() {
        return Optional.empty();
    }

    public Optional<String> getReason() {
        return reason;
    }
}
