package ru.yandex.calendar.logic.mailer;

import ru.yandex.bolts.collection.Option;

/**
 * @author dbrylev
 */
public class MailerHandlingResult {

    public final Status status;
    public final Option<String> reason;

    private MailerHandlingResult(Status status, Option<String> reason) {
        this.status = status;
        this.reason = reason;
    }

    public static MailerHandlingResult sent() {
        return new MailerHandlingResult(Status.SENT, Option.empty());
    }

    public static MailerHandlingResult skipped(String reason) {
        return new MailerHandlingResult(Status.SKIPPED, Option.of(reason));
    }

    public static MailerHandlingResult returned(String reason) {
        return new MailerHandlingResult(Status.RETURNED, Option.of(reason));
    }

    public enum Status {
        SENT,
        SKIPPED,
        RETURNED,
    }
}
