package ru.yandex.calendar.logic.mailer;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author dbrylev
 */
public class MailerUsers {
    @Autowired
    private DynamicPropertyManager dynamicPropertyManager;
    @Autowired
    private UserManager userManager;

    public final DynamicProperty<ListF<String>> mailerUsers = new DynamicProperty<>("mailerUsers", Cf.list());
    public final DynamicProperty<ListF<String>> mailerOffUsers = new DynamicProperty<>("mailerOffUsers", Cf.list());
    public final DynamicProperty<Boolean> mailerForEverybody = new DynamicProperty<>("mailerForEverybody", false);

    public volatile ListF<PassportUid> mailerUserUids = Cf.list();
    public volatile ListF<PassportUid> mailerOffUserUids = Cf.list();

    public boolean isMailerUser(PassportUid uid) {
        return uid.isYandexTeamRu() && !mailerOffUserUids.containsTs(uid)
                && (mailerForEverybody.get() || mailerUserUids.containsTs(uid));
    }

    public boolean isMailerUserStrict(PassportUid uid) {
        return uid.isYandexTeamRu() && mailerUserUids.containsTs(uid);
    }

    @PostConstruct
    public void setup() {
        Function<ListF<String>, ListF<PassportUid>> resolve = users -> users.filterMap(u ->
                Cf.Long.parseSafe(u).map(PassportUid::cons).orElse(() -> Option.x(userManager.getYtUserUidByLogin(u))));

        dynamicPropertyManager.registerAndFireWatcher(mailerUsers, us -> mailerUserUids = resolve.apply(us));
        dynamicPropertyManager.registerAndFireWatcher(mailerOffUsers, us -> mailerOffUserUids = resolve.apply(us));
    }
}
