package ru.yandex.calendar.logic.mailer.change;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.MailerEvent;
import ru.yandex.calendar.logic.mailer.model.MailerAttendees;
import ru.yandex.calendar.logic.mailer.model.MailerGroup;
import ru.yandex.calendar.logic.mailer.model.MailerParticipant;

/**
 * @author dbrylev
 */
public class MailerGroupChangesFinder {

    public static boolean isFresher(MailerEvent left, MailerEvent right) {
        return left.getSequence() > right.getSequence()
                || left.getSequence() == right.getSequence()
                && left.getDtstamp().isAfter(right.getDtstamp());
    }

    public static MailerGroupChangesInfo changes(Option<MailerGroup> our, MailerGroup their, boolean isCancel) {
        Option<MailerEvent> ourMaster = our.flatMapO(MailerGroup::getMaster);

        if (their.getMaster().isPresent()) {
            MailerEvent theirMaster = their.getMaster().get();

            if (!ourMaster.exists(m -> !isFresher(theirMaster, m))) {

                MailerEventChange forMail = Option.when(isCancel, () -> MailerEventChange.cancelled(theirMaster))
                        .orElse(() -> ourMaster.map(m -> MailerEventChange.updated(m, theirMaster)))
                        .getOrElse(() -> MailerEventChange.created(theirMaster));

                return MailerGroupChangesInfo.of(forMail,
                        our.flatMap(MailerGroup::getEvents),
                        isCancel ? Cf.list() : their.getEvents());
            }
        } else {
            MapF<Instant, MailerEvent> ourById = our.flatMap(MailerGroup::getRecurrences)
                    .toMapMappingToKey(e -> e.getRecurrenceId().get());

            ListF<MailerEvent> theirFresh = their.getRecurrences().filterNot(
                    t -> ourById.getO(t.getRecurrenceId().get()).exists(o -> !isFresher(t, o)));

            if (theirFresh.isNotEmpty()) {
                MailerEvent theirRecurrence = theirFresh.first();

                MailerEventChange forMail = Option.when(isCancel, () -> MailerEventChange.cancelled(theirRecurrence))
                        .orElse(() -> ourById.getO(theirRecurrence.getRecurrenceId().get())
                                .map(o -> MailerEventChange.updated(o, theirRecurrence)))
                        .orElse(() -> ourMaster.map(m -> MailerEventChange.updated(m, theirRecurrence)))
                        .getOrElse(() -> MailerEventChange.created(theirFresh.first()));

                ListF<LocalDate> theirDates = theirFresh.map(
                        e -> new LocalDate(e.getRecurrenceId().get(), DateTimeZone.forID(e.getTimezoneId())));

                CollectionF<MailerEvent> ourMatch = ourById.values().filter(theirDates.containsF().compose(
                        e -> new LocalDate(e.getRecurrenceId().get(), DateTimeZone.forID(e.getTimezoneId()))));

                return MailerGroupChangesInfo.of(forMail, ourMatch, isCancel ? Cf.list() : theirFresh);
            }
        }
        return new MailerGroupChangesInfo(MailerEventChange.ignored(), Cf.list(), Cf.list(), Cf.list());
    }

    public static MailerEvent mergeAttendees(MailerEvent before, MailerEvent after) {
        if (before.getAttendees().attendees.isNotEmpty() && !after.getAttendees().attendees.map(MailerParticipant::getId)
                .exists(before.getAttendees().attendees.map(MailerParticipant::getId).unique()::containsTs))
        {
            after = after.copy();
            after.setAttendees(new MailerAttendees(
                    before.getAttendees().attendees.plus(after.getAttendees().attendees)));
        }
        return after;
    }
}
