package ru.yandex.calendar.logic.mailer.change;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.MailerEvent;
import ru.yandex.calendar.logic.mailer.model.MailerEventId;

/**
 * @author dbrylev
 */
public class MailerGroupChangesInfo {
    private final MailerEventChange forMail;

    private final ListF<MailerEventId> delete;
    private final ListF<MailerEvent> update;
    private final ListF<MailerEvent> create;

    public MailerGroupChangesInfo(
            MailerEventChange forMail,
            ListF<MailerEventId> delete,
            ListF<MailerEvent> update,
            ListF<MailerEvent> create)
    {
        this.forMail = forMail;
        this.delete = delete;
        this.update = update;
        this.create = create;
    }

    public static MailerGroupChangesInfo of(
            MailerEventChange forMail, CollectionF<MailerEvent> before, CollectionF<MailerEvent> after)
    {
        Instant now = Instant.now();

        MapF<Option<Instant>, MailerEvent> beforeById = before.toMapMappingToKey(MailerEvent::getRecurrenceId);
        MapF<Option<Instant>, MailerEvent> afterById = after.toMapMappingToKey(MailerEvent::getRecurrenceId);

        if (forMail.isUpdated()) {
            forMail = forMail.withCurrent(Option.of(
                    MailerGroupChangesFinder.mergeAttendees(forMail.getPrevious().get(), forMail.getCurrent().get())));
        }

        return new MailerGroupChangesInfo(forMail,

                before.filterMap(b -> Option.when(!afterById.containsKeyTs(b.getRecurrenceId()), MailerEventId.of(b))),

                before.filterMap(b -> afterById.getO(b.getRecurrenceId()).map(a -> {
                    MailerEvent ac = MailerGroupChangesFinder.mergeAttendees(b, a).copy();

                    ac.setCreated(b.getCreated());
                    ac.setModified(now);

                    return ac;
                })),

                after.filterMap(a -> Option.when(!beforeById.containsKeyTs(a.getRecurrenceId()), a).map(e -> {
                    MailerEvent ec = e.copy();
                    ec.setCreated(now);
                    ec.setModified(now);

                    return ec;
                })));
    }

    public MailerEventChange getForMail() {
        return forMail;
    }

    public ListF<MailerEventId> getDelete() {
        return delete;
    }

    public ListF<MailerEvent> getUpdate() {
        return update;
    }

    public ListF<MailerEvent> getCreate() {
        return create;
    }

    public MailerGroupChangesInfo withForMail(MailerEventChange forMail) {
        return new MailerGroupChangesInfo(forMail, delete, update, create);
    }

    public MailerGroupChangesInfo withCreate(ListF<MailerEvent> create) {
        return new MailerGroupChangesInfo(forMail, delete, update, create);
    }

    public boolean isEmpty() {
        return delete.isEmpty() && update.isEmpty() && delete.isEmpty() && forMail.isIgnored();
    }
}
