package ru.yandex.calendar.logic.mailer.logbroker;

import java.util.concurrent.ThreadPoolExecutor;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.inside.logbroker.pull.consumer.LbSimpleAsyncLineListener;
import ru.yandex.inside.logbroker.pull.consumer.SingleClientIdLbConsumerContextConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import(SingleClientIdLbConsumerContextConfiguration.class)
public class MailAttachLogContextConfiguration {

    @Bean
    public MailAttachLogListener mailAttachLogListener() {
        return new MailAttachLogListener();
    }

    @Bean
    public LbSimpleAsyncLineListener lbConsumerListener(
            MailAttachLogListener mailAttachLogListener,
            @Qualifier("lbListenerExecutor") ThreadPoolExecutor listenerExecutor)
    {
        return new LbSimpleAsyncLineListener(mailAttachLogListener, listenerExecutor);
    }
}
