package ru.yandex.calendar.logic.mailer.model;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.sharing.Decision;

@Data
public class FoundEvent {
    public final Option<EventIdLogDataJson> id;
    public final Option<Decision> decision;
    public final Option<String> privateToken;
    public final boolean masterAttendee;
    public final boolean deleted;

    public boolean isFound() {
        return id.isPresent();
    }

    public boolean isInvitationFound() {
        return decision.isPresent();
    }
}
