package ru.yandex.calendar.logic.mailer.model;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.JsonizableValue;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class MailerAttendees implements JsonizableValue {

    public final ListF<MailerParticipant> attendees;

    @FillWithSomething
    public MailerAttendees(ListF<MailerParticipant> attendees) {
        this.attendees = attendees;
    }

    public static MailerAttendees fromDbValue(String value) {
        return new MailerAttendees(MailerParticipant.bender.getParser().parseListJson(value));
    }

    @Override
    public String toDbValue() {
        return new String(MailerParticipant.bender.getSerializer().serializeListJson(attendees));
    }

    @Override
    public String toString() {
        return toDbValue();
    }
}
