package ru.yandex.calendar.logic.mailer.model;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple3;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.calendar.logic.beans.generated.MailerEvent;
import ru.yandex.calendar.logic.beans.generated.MailerEventFields;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author dbrylev
 */
public class MailerEventId {
    private final MailerGroupId groupId;
    private final long instanceId;

    @FillWithSomething
    public MailerEventId(MailerGroupId groupId, Option<Instant> recurrenceId) {
        this.groupId = groupId;
        this.instanceId = recurrenceId.map(Instant::getMillis).getOrElse(0L);
    }

    public static MailerEventId of(MailerEvent event) {
        return new MailerEventId(new MailerGroupId(event.getUid(), event.getExternalId()), event.getRecurrenceId());
    }

    public PassportUid getUid() {
        return groupId.getUid();
    }

    public String getExternalId() {
        return groupId.getExternalId();
    }

    public Tuple3<PassportUid, String, Long> asTuple() {
        return Tuple3.tuple(groupId.getUid(), groupId.getExternalId(), instanceId);
    }

    public static ListF<MapField<?>> fields() {
        return Cf.list(MailerEventFields.UID, MailerEventFields.EXTERNAL_ID, MailerEventFields.INSTANCE_ID);
    }

    public static SqlCondition inSet(CollectionF<MailerEventId> ids) {
        return BeanHelper.fieldsInSetCondition(fields(), ids.map(MailerEventId::asTuple));
    }

    public SqlCondition eq() {
        return inSet(Cf.set(this));
    }
}
