package ru.yandex.calendar.logic.mailer.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.calendar.logic.beans.generated.MailerEventFields;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author dbrylev
 */
public class MailerGroupId {
    private final PassportUid uid;
    private final String externalId;

    @FillWithSomething
    public MailerGroupId(PassportUid uid, String externalId) {
        this.uid = uid;
        this.externalId = externalId;
    }

    public PassportUid getUid() {
        return uid;
    }

    public String getExternalId() {
        return externalId;
    }

    public Tuple2<PassportUid, String> asTuple() {
        return Tuple2.tuple(uid, externalId);
    }

    public static ListF<MapField<?>> fields() {
        return Cf.list(MailerEventFields.UID, MailerEventFields.EXTERNAL_ID);
    }

    public static SqlCondition inSet(CollectionF<MailerGroupId> ids) {
        return BeanHelper.fieldsInSetCondition(fields(), ids.map(MailerGroupId::asTuple));
    }

    public SqlCondition eq() {
        return inSet(Cf.set(this));
    }
}
