package ru.yandex.calendar.logic.notification;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;

/**
 * @author Daniel Brylev
 */
public enum Channel implements StringEnum {
    EMAIL,
    SMS,
    SVC,
    DISPLAY,
    AUDIO,
    YAMB,
    XIVA,
    PANEL,
    MOBILE,
    ;

    public static final StringEnumResolver<Channel> R = StringEnumResolver.r(Channel.class);

    @Override
    public String value() {
        return CamelWords.parse(this.name()).toDbName();
    }

}
