package ru.yandex.calendar.logic.notification;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.beans.generated.EventNotification;
import ru.yandex.misc.lang.Validate;

/**
 * @author Daniel Brylev
 */
public class EventNotificationChangesInfo {

    private final ListF<Long> deleteNotificationIds;
    private final ListF<EventNotification> createNotifications;
    private final long eventUserId;

    public EventNotificationChangesInfo(
            ListF<Long> deleteNotificationIds,
            ListF<EventNotification> createNotifications,
            long eventUserId)
    {
        Validate.isFalse(createNotifications.exists(EventNotification.isIdFieldsSetF()));
        this.deleteNotificationIds = deleteNotificationIds;
        this.createNotifications = createNotifications;
        this.eventUserId = eventUserId;
    }

    public ListF<Long> getDeleteNotificationIds() {
        return deleteNotificationIds;
    }

    public ListF<EventNotification> getCreateNotifications() {
        return createNotifications;
    }

    public long getEventUserId() {
        return eventUserId;
    }

    public boolean wasChanges() {
        return deleteNotificationIds.isNotEmpty() || createNotifications.isNotEmpty();
    }

    public static Function1B<EventNotificationChangesInfo> wasChangesF() {
        return new Function1B<EventNotificationChangesInfo>() {
            public boolean apply(EventNotificationChangesInfo n) {
                return n.wasChanges();
            }
        };
    }

    public static Function<EventNotificationChangesInfo, Long> getEventUserIdF() {
        return new Function<EventNotificationChangesInfo, Long>() {
            public Long apply(EventNotificationChangesInfo n) {
                return n.getEventUserId();
            }
        };
    }

    public static Function<EventNotificationChangesInfo, ListF<Long>> getDeleteNotificationIdsF() {
        return new Function<EventNotificationChangesInfo, ListF<Long>>() {
            public ListF<Long> apply(EventNotificationChangesInfo n) {
                return n.getDeleteNotificationIds();
            }
        };
    }

    public static Function<EventNotificationChangesInfo, ListF<EventNotification>> getCreateNotificationsF() {
        return new Function<EventNotificationChangesInfo, ListF<EventNotification>>() {
            public ListF<EventNotification> apply(EventNotificationChangesInfo n) {
                return n.getCreateNotifications();
            }
        };
    }

}
