package ru.yandex.calendar.logic.notification;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.EventNotification;
import ru.yandex.misc.lang.Validate;

/**
 * @author Daniel Brylev
 */
public class EventNotifications {

    private final long eventUserId;
    private final ListF<EventNotification> notifications;

    EventNotifications(long eventUserId, ListF<EventNotification> notifications) {
        Validate.forAll(notifications, EventNotification.getEventUserIdF().andThenEquals(eventUserId));
        Validate.forAll(notifications, EventNotification.isIdFieldsSetF());
        this.eventUserId = eventUserId;
        this.notifications = notifications;
    }

    public static EventNotifications empty() {
        return new EventNotifications(0L, Cf.list());
    }

    public long getEventUserId() {
        return eventUserId;
    }

    public ListF<EventNotification> getEventNotifications() {
        return notifications;
    }

    public ListF<Notification> getNotifications() {
        return notifications.map(Notification::of);
    }

}
