package ru.yandex.calendar.logic.notification;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.beans.generated.EventNotification;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.Validate;

/**
 * @author ssytnik
 */
public class EventUserWithNotifications {
    private EventUser eventUser;
    private EventNotifications notifications;

    public EventUserWithNotifications(EventUser eu, EventNotifications n) {
        Validate.notNull(eu);
        Validate.notNull(n);
        this.eventUser = eu;
        this.notifications = n;
    }

    public EventUser getEventUser() {
        return eventUser;
    }

    public EventNotifications getNotifications() {
        return notifications;
    }

    public ListF<EventNotification> getEventNotifications() {
        return notifications.getEventNotifications();
    }

    public ListF<EventNotification> getEventNotifications(Channel channel) {
        return getEventNotifications().filter(EventNotification.getChannelF().andThenEquals(channel));
    }

    @Override
    public String toString() {
        try {
            return "{eu.id = " + eventUser.getId() + "; " + " some notifications}";
        } catch (Exception e) {
            return "{error: " + e + "}";
        }
    }

    public ListF<EventUserWithNotification> split() {
        return getNotifications().getEventNotifications().map(ns -> new EventUserWithNotification(eventUser, ns));
    }

    public static Function2<EventUser, EventNotifications, EventUserWithNotifications> consF() {
        return new Function2<EventUser, EventNotifications, EventUserWithNotifications>() {
            public EventUserWithNotifications apply(EventUser eventUser, EventNotifications notification) {
                return new EventUserWithNotifications(eventUser, notification);
            }
        };
    }

    public static Function<EventUserWithNotifications, EventUser> getEventUserF() {
        return new Function<EventUserWithNotifications, EventUser>() {
            public EventUser apply(EventUserWithNotifications eventUserWithNotifications) {
                return eventUserWithNotifications.getEventUser();
            }
        };
    }

    public static Function<EventUserWithNotifications, EventNotifications> getNotificationsF() {
        return new Function<EventUserWithNotifications, EventNotifications>() {
            public EventNotifications apply(EventUserWithNotifications eventUserWithNotifications) {
                return eventUserWithNotifications.getNotifications();
            }
        };
    }

    public static Function<EventUserWithNotifications, Long> getEventIdF() {
        return getEventUserF().andThen(EventUser.getEventIdF());
    }

    public static Function<EventUserWithNotifications, Long> getEventUserIdF() {
        return getEventUserF().andThen(EventUser.getIdF());
    }

    public static Function<EventUserWithNotifications, Decision> getDecisionF() {
        return getEventUserF().andThen(EventUser.getDecisionF());
    }

    public static Function<EventUserWithNotifications, PassportUid> getUidF() {
        return getEventUserF().andThen(EventUser.getUidF());
    }

    public static Function<EventUserWithNotifications, ListF<EventUserWithNotification>> splitF() {
        return new Function<EventUserWithNotifications, ListF<EventUserWithNotification>>() {
            public ListF<EventUserWithNotification> apply(EventUserWithNotifications e) {
                return e.split();
            }
        };
    }

}
