package ru.yandex.calendar.logic.notification;

import org.joda.time.Duration;

import ru.yandex.calendar.logic.beans.generated.EventNotification;
import ru.yandex.calendar.logic.beans.generated.LayerNotification;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Daniel Brylev
 */
@Bendable
public class Notification extends DefaultObject {
    @BenderPart(name = "channel")
    private Channel channel;
    @BenderPart(name = "offset")
    private final Duration offset;

    public Notification( Channel channel, Duration offset) {
        this.channel = channel;
        this.offset = offset;
    }

    public static Notification of(EventNotification en) {
        return new Notification(en.getChannel(), Duration.standardMinutes(en.getOffsetMinute()));
    }

    public static Notification of(LayerNotification ln) {
        return new Notification(ln.getChannel(), Duration.standardMinutes(ln.getOffsetMinute()));
    }

    public EventNotification toEventNotification(long eventUserId) {
        EventNotification notification = new EventNotification();
        notification.setEventUserId(eventUserId);
        notification.setChannel(getChannel());
        notification.setOffsetMinute(getOffsetMinutes());
        notification.setNextSendTsNull();
        return notification;
    }

    public LayerNotification toLayerNotification(long layerUserId) {
        LayerNotification notification = new LayerNotification();
        notification.setLayerUserId(layerUserId);
        notification.setChannel(getChannel());
        notification.setOffsetMinute(getOffsetMinutes());
        return notification;
    }

    public int getOffsetMinutes() {
        return (int) offset.getStandardMinutes();
    }

    public Duration getOffset() {
        return offset;
    }

    public Channel getChannel() {
        return channel;
    }

    public boolean channelIs(Channel channel) {
        return this.channel == channel;
    }

    public static Notification email(Duration offset) {
        return new Notification(Channel.EMAIL, offset);
    }

    public static Notification sms(Duration offset) {
        return new Notification(Channel.SMS, offset);
    }

    public static Notification svc(Duration offset) {
        return new Notification(Channel.SVC, offset);
    }

    public static Notification display(Duration offset) {
        return new Notification(Channel.DISPLAY, offset);
    }

    public static Notification audio(Duration offset) {
        return new Notification(Channel.AUDIO, offset);
    }
}
