package ru.yandex.calendar.logic.notification;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.calendar.logic.beans.generated.EventNotification;

/**
 * @author Daniel Brylev
 */
public class NotificationChangesFinder {

    public static ListF<EventNotificationChangesInfo> changes(
            ListF<EventNotifications> notificationsList, final NotificationsData.Update updates)
    {
        return notificationsList.map(new Function<EventNotifications, EventNotificationChangesInfo>() {
            public EventNotificationChangesInfo apply(EventNotifications notifications) {
                return changes(notifications, updates);
            }
        });
    }

    public static EventNotificationChangesInfo changes(
            EventNotifications notifications, NotificationsData.Update updates)
    {
        SetF<Channel> affectedChannels = updates.getChannelsToUpdate();
        Function1B<EventNotification> affectedF = EventNotification.getChannelF().andThen(affectedChannels.containsF());

        long eventUserId = notifications.getEventUserId();
        ListF<EventNotification> oldList = notifications.getEventNotifications().filter(affectedF);
        ListF<EventNotification> newList = updates.getNotifications().map(n -> n.toEventNotification(eventUserId));

        Comparator<EventNotification> comparator = EventNotification.getChannelF().andThenNaturalComparator()
                .thenComparing(EventNotification.getOffsetMinuteF().andThenNaturalComparator());
        Changes<EventNotification> changes = changes(oldList, newList, comparator);

        ListF<Long> deleteNotificationIds = changes.removed.map(EventNotification.getIdF());
        ListF<EventNotification> createNotifications = changes.added;

        return new EventNotificationChangesInfo(deleteNotificationIds, createNotifications, eventUserId);
    }

    private static <T> Changes<T> changes(ListF<T> oldList, ListF<T> newList, Comparator<T> comparator) {
        ListF<T> removed = Cf.arrayList();
        ListF<T> added = Cf.arrayList();

        oldList = oldList.sorted(comparator);
        newList = newList.sorted(comparator);

        IteratorF<T> oldListIterator = oldList.iterator();
        IteratorF<T> newListIterator = newList.iterator();
        Option<T> oldO = oldListIterator.nextO();
        Option<T> newO = newListIterator.nextO();

        while (oldO.isPresent() || newO.isPresent()) {
            if (oldO.isPresent() && (!newO.isPresent() || comparator.lt(oldO.get(), newO.get()))) {
                removed.add(oldO.get());
                oldO = oldListIterator.nextO();

            } else if (newO.isPresent() && (!oldO.isPresent() || comparator.gt(oldO.get(), newO.get()))) {
                added.add(newO.get());
                newO = newListIterator.nextO();

            } else {
                oldO = oldListIterator.nextO();
                newO = newListIterator.nextO();
            }
        }
        return new Changes<T>(removed, added);
    }

    private static class Changes<T> {
        ListF<T> removed;
        ListF<T> added;

        private Changes(ListF<T> removed, ListF<T> added) {
            this.removed = removed;
            this.added = added;
        }
    }

}
