package ru.yandex.calendar.logic.notification;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.frontend.yamb.Yamb;
import ru.yandex.calendar.util.HttpClientConfiguration;

@Configuration
public class NotificationContextConfiguration {

    @Bean
    public ControlDataNotification controlDataNotification() {
        return new ControlDataNotification();
    }

    @Bean
    public NotificationDbManager notificationDbManager() {
        return new NotificationDbManager();
    }

    @Bean
    public NotificationSendManager notificationSendManager() {
        return new NotificationSendManager();
    }

    @Bean
    public SmsNotificationManager smsNotificationManager() { return new SmsNotificationManager(); }

    @Bean
    public Yamb yamb(MeterRegistry registry) {
        return new Yamb(HttpClientConfiguration.fromProperties("yamb"), registry);
    }
}
