package ru.yandex.calendar.logic.notification;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.log.LogEvent;
import ru.yandex.calendar.logic.log.LogEventType;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class NotificationLogEventJson extends LogEvent {
    private final Optional<String> email;
    private final Optional<String> smsId;
    private final Optional<String> messageId;
    private final Optional<String> error;
    private final Optional<NotificationSkipReason> skipReason;
    private final String uid;
    private final Channel channel;
    private final Instant sendTs;
    @JsonUnwrapped
    private final EventIdLogDataJson evIdLogData;
    private final Long eventUserId;
    private final Instant eventStartTs;
    private final Long eventNotificationId;
    private final NotificationStatus status;

    public NotificationLogEventJson(
            NotificationSendManager.NotificationInfo notification, NotificationSendResult result)
    {
        this.email = result.email.map(Email::getEmail).toOptional();
        this.smsId = result.smsId.toOptional();
        this.messageId = result.messageId.toOptional();
        this.error = result.error.toOptional();
        this.skipReason = result.skipReason.toOptional();
        this.uid = notification.getUid().toString();
        this.channel = notification.getNotification().getChannel();
        this.sendTs = notification.getNotification().getNextSendTs().get();
        this.evIdLogData = notification.getEventIdLogData();
        this.eventUserId = notification.getEventUser().getId();
        this.eventStartTs = notification.getInstanceStartTs();
        this.eventNotificationId = notification.getNotification().getId();
        this.status = result.status;
    }

    @JsonGetter
    @Override
    public LogEventType type() {
        return LogEventType.EVENT_REMINDER;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public boolean isOmitDatabasing(ActionInfo actionInfo) {
        return status == NotificationStatus.SKIPPED
                && !Cf.Long.parseSafe(uid).map(PassportUid::cons).exists(PassportUid::isYandexTeamRu);
    }

    @Override
    public Optional<EventIdLogDataJson> getEventId() {
        return Optional.of(evIdLogData);
    }
}
