package ru.yandex.calendar.logic.notification;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class NotificationSendResult {
    public final NotificationStatus status;
    public final Option<Email> email;

    public final Option<String> smsId;
    public final Option<String> messageId;
    public final Option<String> error;

    public final Option<NotificationSkipReason> skipReason;

    private NotificationSendResult(
            NotificationStatus status, Option<Email> email,
            Option<String> smsId, Option<String> messageId,
            Option<String> error, Option<NotificationSkipReason> skipReason)
    {
        this.status = status;
        this.error = error;
        this.email = email;
        this.smsId = smsId;
        this.messageId = messageId;
        this.skipReason = skipReason;
    }

    public static NotificationSendResult cons(NotificationStatus status) {
        return new NotificationSendResult(
                status, Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty());
    }

    public static NotificationSendResult skipped(Option<NotificationSkipReason> reason) {
        return new NotificationSendResult(
                NotificationStatus.SKIPPED, Option.empty(), Option.empty(), Option.empty(), Option.empty(), reason);
    }

    public static NotificationSendResult processed(Email email, String messageId) {
        return new NotificationSendResult(
                NotificationStatus.PROCESSED, Option.of(email),
                Option.empty(), Option.of(messageId), Option.empty(), Option.empty());
    }

    public static NotificationSendResult processed(String smsId) {
        return new NotificationSendResult(
                NotificationStatus.PROCESSED, Option.empty(),
                Option.of(smsId), Option.empty(), Option.empty(), Option.empty());
    }

    public static NotificationSendResult fatalError(Exception e) {
        return new NotificationSendResult(
                NotificationStatus.FATAL_ERROR, Option.empty(), Option.empty(), Option.empty(),
                Option.of(ExceptionUtils.getAllMessages(e)), Option.empty());
    }

    public static NotificationSendResult tryAgain(Exception e) {
        return new NotificationSendResult(
                NotificationStatus.TRY_AGAIN, Option.empty(), Option.empty(), Option.empty(),
                Option.of(ExceptionUtils.getAllMessages(e)), Option.empty());
    }

    @Override
    public String toString() {
        return "NotificationSendResult{" +
                "status=" + status +
                ", email=" + email +
                ", smsId=" + smsId +
                ", messageId=" + messageId +
                ", error=" + error +
                ", skipReason=" + skipReason +
                '}';
    }
}
