package ru.yandex.calendar.logic.notification;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.NotificationSendStat;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.test.random.RunWithRandomTest;

/**
 * @author Sergey Shinderuk
 */
public class NotificationSendStatDao extends CalendarJdbcDaoSupport {

    @Autowired
    private GenericBeanDao genericBeanDao;

    public void saveNotificationSendStat(NotificationSendStat stat) {
        genericBeanDao.insertBean(stat);
    }

    @RunWithRandomTest
    public Option<NotificationSendStat> findLastNotificationSendStat() {
        String q = "SELECT * FROM notification_send_stat ORDER BY task_start_ts DESC LIMIT 1";
        return getJdbcTemplate().queryForOption(q, NotificationSendStat.class);
    }

    @RunWithRandomTest
    public Option<NotificationSendStat> findLastNotificationSendStat(String taskReqId) {
        String q = "SELECT * FROM notification_send_stat WHERE task_req_id = ? ORDER BY task_end_ts DESC LIMIT 1";
        return getJdbcTemplate().queryForOption(q, NotificationSendStat.class, taskReqId);
    }

}
