package ru.yandex.calendar.logic.notification;

/**
 * Notification handling status
 * @author ssytnik
 */
public enum NotificationStatus {
    /**
     * Notification has processed successfully,
     * e.g.: it's off, nowhere to send, sent etc.
     * Actions: recalculation.
     */
    PROCESSED,
    /**
     * Sending retry is required.
     * Actions: log, error flag.
     */
    TRY_AGAIN,
    /**
     * Fatal error, abandon current notification.
     * Actions: log, error flag, recalculation.
     */
    FATAL_ERROR,
    /**
     * Nothing to send if notification is off or has channel like display.
     * Actions: recalculation.
     */
    SKIPPED,
    ;
}
