package ru.yandex.calendar.logic.notification;

import org.jdom.Element;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * @author Daniel Brylev
 */
public class NotificationXmlizer {

    private static final SetF<Channel> OUT_CHANNELS = NotificationsData.WEB_CHANNELS.minus1(Channel.SVC);

    public static void appendElmForWeb(Element eParent, ListF<Notification> notifications) {
        notifications = notifications.filter(n -> OUT_CHANNELS.containsTs(n.getChannel()));

        ListF<Channel> channels = notifications.map(Notification::getChannel);

        CalendarXmlizer.appendElm(eParent, "notifications", notifications.toTuple2List(
                n -> n.getChannel().value(),
                n -> n.getOffset().getStandardMinutes()).mkString(";", ","));

        if (channels.isNotEmpty()) {
            ListF<Duration> sortedAllOffsets = notifications.map(Notification::getOffset).unique().sorted();
            ListF<Long> offsetsMinutes = sortedAllOffsets.map(AuxDateTime.durationToMinutesF());

            Element element = new Element("notification");
            CalendarXmlizer.appendElm(element, "offsets-min", offsetsMinutes.mkString(","));
            CalendarXmlizer.appendElm(element, "is-email-notify", channels.containsTs(Channel.EMAIL));
            CalendarXmlizer.appendElm(element, "is-sms-notify", channels.containsTs(Channel.SMS));
            CalendarXmlizer.appendElm(element, "is-ical-display-notify", channels.containsTs(Channel.DISPLAY));
            CalendarXmlizer.appendElmColl(element, "offsets-min-list", "offset-min", offsetsMinutes);
            eParent.addContent(element);
        }
    }

    public static void appendElmForCmdGetSettings(Element eParent, ListF<Notification> notifications, boolean withOffsets) {
        notifications = notifications.filter(n -> OUT_CHANNELS.containsTs(n.getChannel()));

        ListF<Duration> sortedAllOffsets = notifications.map(Notification::getOffset).unique().sorted();
        ListF<Long> offsetsMinutes = sortedAllOffsets.map(AuxDateTime.durationToMinutesF());

        if (offsetsMinutes.isEmpty()) {
            offsetsMinutes = Cf.list(-15L);
        }
        ListF<Channel> channels = notifications.map(Notification::getChannel);
        Element element = new Element("notification");
        CalendarXmlizer.appendElm(element, "offsets-min", offsetsMinutes.mkString(","));
        CalendarXmlizer.appendElm(element, "is-email-notify", channels.containsTs(Channel.EMAIL));
        CalendarXmlizer.appendElm(element, "is-sms-notify", channels.containsTs(Channel.SMS));
        CalendarXmlizer.appendElm(element, "is-ical-display-notify", channels.containsTs(Channel.DISPLAY));
        if (withOffsets) {
            CalendarXmlizer.appendElmColl(element, "offsets-min-list", "offset-min", offsetsMinutes);
        }
        CalendarXmlizer.appendElm(eParent, "notifications", notifications.toTuple2List(
                n -> n.getChannel().value(),
                n -> n.getOffset().getStandardMinutes()).mkString(";", ","));

        eParent.addContent(element);
    }
}
