package ru.yandex.calendar.logic.notification;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.SendingSms;
import ru.yandex.calendar.logic.beans.generated.SendingSmsFields;
import ru.yandex.calendar.logic.beans.generated.SendingSmsHelper;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author dbrylev
 */
public class SendingSmsDao extends CalendarJdbcDaoSupport {

    @Autowired
    private GenericBeanDao genericBeanDao;

    public void saveIgnoreDuplicates(ListF<SendingSms> smss) {
        genericBeanDao.insertBeansIgnoreDuplicates(smss);
    }

    public void updateByUidAndActiveId(PassportUid uid, String id, SendingSms data) {
        genericBeanDao.updateBeans(data, SendingSmsFields.UID.eq(uid).and(SendingSmsFields.ACTIVE_ID.eq(id)));
    }

    public void findNotProcessed(Function1V<SendingSms> callback) {
        genericBeanDao.loadBeans(
                SendingSmsHelper.INSTANCE,
                SendingSmsFields.IS_PROCESSED.eq(false),
                SendingSmsFields.SUBMIT_TS,
                1, callback.compose(Cf.List.singleF()).asFunctionReturnValue(Cf.list()));
    }

    public void deleteByUid(PassportUid uid) {
        genericBeanDao.deleteBeans(SendingSmsHelper.INSTANCE, SendingSmsFields.UID.eq(uid));
    }

    public ListF<SendingSms> findByUid(PassportUid uid) {
        return genericBeanDao.loadBeans(SendingSmsHelper.INSTANCE, SendingSmsFields.UID.eq(uid));
    }
}
