package ru.yandex.calendar.logic.notification.xiva;

import java.util.Optional;

import org.joda.time.Instant;

import ru.yandex.calendar.logic.event.model.EventType;
import ru.yandex.calendar.logic.notification.xiva.content.XivaNotificationType;
import ru.yandex.calendar.logic.user.NameI18n;

public class NotificationPreparedData {
    private final Optional<NameI18n> organizer;
    private final Instant currentStartTs;
    private final Optional<Instant> oldStartTs;
    private final long eventId;
    private final String eventName;
    private final EventType eventType;
    private final XivaNotificationType type;
    private final int ttl;

    public NotificationPreparedData(Optional<NameI18n> organizer,
                                    Instant currentStartTs,
                                    Optional<Instant> oldStartTs,
                                    long eventId,
                                    String eventName,
                                    EventType eventType,
                                    XivaNotificationType type,
                                    int ttl) {
        this.organizer = organizer;
        this.currentStartTs = currentStartTs;
        this.oldStartTs = oldStartTs;
        this.eventName = eventName;
        this.eventId = eventId;
        this.eventType = eventType;
        this.type = type;
        this.ttl = ttl;
    }

    public Optional<NameI18n> getOrganizer() {
        return organizer;
    }

    public Instant getCurrentStartTs() {
        return currentStartTs;
    }

    public Optional<Instant> getOldStartTs() {
        return oldStartTs;
    }

    public long getEventId() {
        return eventId;
    }

    public String getEventName() {
        return eventName;
    }

    public EventType getEventType() {
        return eventType;
    }

    public XivaNotificationType getType() {
        return type;
    }

    public int getTtl() {
        return ttl;
    }
}
