package ru.yandex.calendar.logic.notification.xiva;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class XivaSendNotificationExecutor {
    private static final Logger logger = LoggerFactory.getLogger(XivaSendNotificationExecutor.class);

    private static final DynamicProperty<Integer> batchSizeProp = new DynamicProperty<>("xiva.batchSize", 10);
    private static final DynamicProperty<Integer> batchSendPeriodSecProp = new DynamicProperty<>("xiva.batchSendPeriodSec", 5);

    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public void execute(ListF<PassportUid> uids, Consumer<ListF<PassportUid>> send) {
        try {
            send.accept(uids);
        } catch (Exception e) {
            logger.error("Error occurred while sending notifications", e);
        }
    }

    public void schedule(ListF<PassportUid> uids, Consumer<ListF<PassportUid>> send) {
        var batchSize = batchSizeProp.get();

        for (int batchNum = 0; batchNum * batchSize < uids.size(); batchNum++) {
            var i = batchNum * batchSize;
            var batch = uids.subList(i, Math.min(i + batchSize, uids.size()));
            executor.schedule(() -> {
                try {
                    send.accept(batch);
                } catch (Exception e) {
                    logger.error("Error occurred while sending notifications", e);
                }
            }, batchNum * batchSendPeriodSecProp.get(), TimeUnit.SECONDS); // spread sending push to decrease peak load on sync from browsers
        }
    }
}
