package ru.yandex.calendar.logic.notification.xiva.content;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.NameI18n;

public class TemporaryLocalizedStrings {
    private static final DateTimeFormatter DAY_OF_WEEK_FORMATTER = DateTimeFormatter.ofPattern("EEEE");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd LLLL");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");

    //subtitles
    public static final NameI18n CREATED_EVENT_SUBTITLE = new NameI18n("Новая встреча", "New event");
    public static final NameI18n UPDATED_EVENT_SUBTITLE = new NameI18n("Встреча изменена", "Event updated");
    public static final NameI18n DELETED_EVENT_SUBTITLE = new NameI18n("Встреча отменена", "Event canceled");
    public static final NameI18n STARTING_SOON_SUBTITLE = new NameI18n("Скоро начнётся", "Starting soon");

    //body
    public static final NameI18n ORGANIZER = new NameI18n("Организатор", "Organizer");
    public static final NameI18n WHEN = new NameI18n("Когда", "When");
    public static final NameI18n OLD_DATE = new NameI18n("Было", "It was");
    public static final NameI18n NEW_DATE = new NameI18n("Стало", "Became");
    public static final NameI18n YESTERDAY = new NameI18n("вчера", "yesterday");
    public static final NameI18n TODAY = new NameI18n("сегодня", "today");
    public static final NameI18n TOMORROW = new NameI18n("завтра", "tomorrow");
    public static final NameI18n AT_TIME = new NameI18n("в", "at");
    public static final NameI18n RESOURCES = new NameI18n("Переговорки", "Rooms");
    public static final NameI18n FLOOR = new NameI18n("этаж", "floor");
    public static final NameI18n UNKNOWN_ROOM = new NameI18n("Неизвестная комната", "Unknown room");

    //date and time
    public static String dayOfWeek(Long ts, String zoneId, Language lang) {
        Instant instant = Instant.ofEpochMilli(ts);
        return DAY_OF_WEEK_FORMATTER
                .withLocale(Locale.forLanguageTag(lang.value()))
                .withZone(ZoneId.of(zoneId))
                .format(instant);
    }

    public static String date(Long ts, String zoneId, Language lang) {
        Instant instant = Instant.ofEpochMilli(ts);
        return DATE_FORMATTER
                .withLocale(Locale.forLanguageTag(lang.value()))
                .withZone(ZoneId.of(zoneId))
                .format(instant);
    }

    public static String time(Long ts, String zoneId, Language lang) {
        Instant instant = Instant.ofEpochMilli(ts);
        return TIME_FORMATTER
                .withLocale(Locale.forLanguageTag(lang.value()))
                .withZone(ZoneId.of(zoneId))
                .format(instant);
    }
}
