package ru.yandex.calendar.logic.notification.xiva.content;

import ru.yandex.calendar.frontend.ews.imp.EwsImportStatus;

public enum XivaNotificationType {
    CREATED("calendar-event-created"),
    UPDATED("calendar-event-updated"),
    DELETED("calendar-event-deleted"),
    MEETING_REMINDER("calendar-meeting-reminder"),
    NOT_MEETING_REMINDER("calendar-not-meeting-reminder");

    private final String value;

    XivaNotificationType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static XivaNotificationType fromAction(String action) {
        switch (action) {
            case "createEvent":
                return CREATED;
            case "updateEvent":
                return UPDATED;
            case "deleteEvent":
                return DELETED;
            default:
                throw new IllegalArgumentException("Action '" + action + "' does not supported for xiva notifications");
        }
    }

    public static XivaNotificationType fromEwsImportStatus(EwsImportStatus status) {
        switch (status) {
            case CREATED:
                return CREATED;
            case UPDATED:
                return UPDATED;
            case REMOVED:
                return DELETED;
            default:
                throw new IllegalArgumentException("EwsImportStatus '" + status.name() + "' does not supported for xiva notifications");
        }
    }
}
