package ru.yandex.calendar.logic.notification.xiva.notify;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ModificationInfo;
import ru.yandex.calendar.logic.event.dao.EventUserDao;
import ru.yandex.calendar.logic.event.repetition.EventAndRepetition;
import ru.yandex.calendar.logic.notification.xiva.content.XivaNotificationType;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.util.exception.ExceptionUtils;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class XivaMobileApiNotifier {
    private static final Logger logger = LoggerFactory.getLogger(XivaMobileApiNotifier.class);

    @Autowired
    private XivaCommonManager xivaManager;
    @Autowired
    private EventUserDao eventUserDao;

    public void notify(
            EventAndRepetition createdOrOldEvent,
            PassportUid actorUid,
            Optional<ModificationInfo> modificationInfo,
            ActionInfo actionInfo) {
        try {
            XivaNotificationType type = XivaNotificationType.fromAction(actionInfo.getAction());
            ListF<PassportUid> uids = calculateRecipientUids(
                    createdOrOldEvent.getEvent().getId(),
                    type,
                    modificationInfo);

            xivaManager.handle(createdOrOldEvent, modificationInfo, uids, Option.of(actorUid), type);
        } catch (Exception e) {
            ExceptionUtils.rethrowIfTlt(e);
            logger.error(
                    "Failed to send xivaV2 notification to eventId {}: {}",
                    createdOrOldEvent.getEvent().getId(),
                    e);
        }
    }

    private ListF<PassportUid> calculateRecipientUids(
            long eventId,
            XivaNotificationType type,
            Optional<ModificationInfo> modificationInfo) {
        switch (type) {
            case CREATED:
            case UPDATED:
                return eventUserDao
                        .findEventUsersByEventId(eventId)
                        .filter(EventUser::getIsAttendee)
                        .filter(eu -> eu.getDecision() != Decision.NO)
                        .map(EventUser::getUid);
            case DELETED:
                if (modificationInfo.isEmpty()) {
                    return Cf.list();
                }

                return modificationInfo.get().getEventMails().map(mail -> mail.getRecipientUid().get());
            default:
                return Cf.list();
        }
    }
}
