package ru.yandex.calendar.logic.notification.xiva.notify;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.ews.imp.EwsImportStatus;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.event.EventDbManager;
import ru.yandex.calendar.logic.event.dao.EventUserDao;
import ru.yandex.calendar.logic.event.repetition.EventAndRepetition;
import ru.yandex.calendar.logic.notification.xiva.content.XivaNotificationType;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.calendar.util.exception.ExceptionUtils;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class XivaMobileEwsNotifier {
    private static final Logger logger = LoggerFactory.getLogger(XivaMobileEwsNotifier.class);

    @Autowired
    private XivaCommonManager xivaManager;
    @Autowired
    private EventDbManager eventDbManager;
    @Autowired
    private EventUserDao eventUserDao;

    public void notify(long eventId, EwsImportStatus status, UidOrResourceId subjectId) {
        try {
            XivaNotificationType type = XivaNotificationType.fromEwsImportStatus(status);
            ListF<PassportUid> uids = eventUserDao.findEventUsersByEventId(eventId)
                    .map(EventUser::getUid);
            Option<PassportUid> actorUid = subjectId.getUidO();
            EventAndRepetition event = eventDbManager.getEventAndRepetitionById(eventId);

            xivaManager.handle(event, uids, actorUid, type);
        } catch (Exception e) {
            ExceptionUtils.rethrowIfTlt(e);
            logger.error("Failed to send xivaV2 notification to eventId {}: {}", eventId, e);
        }
    }
}
