package ru.yandex.calendar.logic.notification.xiva.notify;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.EventDbManager;
import ru.yandex.calendar.logic.event.EventWithRelations;
import ru.yandex.calendar.logic.event.repetition.EventAndRepetition;
import ru.yandex.calendar.logic.notification.xiva.content.XivaNotificationType;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class XivaMobileReminderNotifier {
    private static final Logger logger = LoggerFactory.getLogger(XivaMobileReminderNotifier.class);

    @Autowired
    private XivaCommonManager xivaManager;
    @Autowired
    private EventDbManager eventDbManager;

    public void notifyOrThrow(PassportUid uid, EventWithRelations eventWithRelations) {
        try {
            XivaNotificationType type = reminderType(eventWithRelations);
            ListF<PassportUid> uids = Cf.list(uid);
            EventAndRepetition eventAndRepetition = eventDbManager.getEventAndRepetitionById(eventWithRelations.getId());

            logger.info("Start sending reminder notifications for user {}, eventId {}", uid, eventWithRelations.getEvent().getId());
            xivaManager.handleSynchronously(eventAndRepetition, uids, Option.empty(), eventWithRelations.getResources(), type);
        } catch (Exception e) {
            logger.error("Failed to send xivaV2 notification to eventId {}: {}", eventWithRelations.getEvent().getId(), e);
            throw e;
        }
    }

    private XivaNotificationType reminderType(EventWithRelations eventWithRelations) {
        if (eventWithRelations.isMeeting()) {
            return XivaNotificationType.MEETING_REMINDER;
        } else {
            return XivaNotificationType.NOT_MEETING_REMINDER;
        }
    }
}
