package ru.yandex.calendar.logic.organization;


import org.intellij.lang.annotations.Language;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.Organization;
import ru.yandex.calendar.logic.beans.generated.OrganizationFields;
import ru.yandex.calendar.logic.beans.generated.OrganizationHelper;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.mapObject.MapObjectDescription;
import ru.yandex.commune.test.random.RunWithRandomTest;


public class OrganizationDao extends CalendarJdbcDaoSupport {
    @Autowired
    private GenericBeanDao genericBeanDao;

    @RunWithRandomTest
    public ListF<Organization> findOrganizationByDirectoryIds(ListF<Long> directoryIds) {
        return genericBeanDao.loadBeans(
                OrganizationHelper.INSTANCE,
                OrganizationFields.DIRECTORY_ID.column().inSet(directoryIds));
    }

    @RunWithRandomTest
    public ListF<Organization> findOrganizationByIds(ListF<Long> ids) {
        return genericBeanDao.loadBeans(OrganizationHelper.INSTANCE, OrganizationFields.ID.column().inSet(ids));
    }

    public ListF<Organization> createOrganizationsByDirectoryIds(ListF<Long> directoryIds) {
        if (directoryIds.isEmpty()) {
            return Cf.list();
        }

        MapObjectDescription beanDescription = OrganizationFields.OBJECT_DESCRIPTION;
        @Language("SQL") String query = genericBeanDao.getInsertOnConflictIgnoreStatement(
                beanDescription,
                Cf.list(OrganizationFields.DIRECTORY_ID),
                directoryIds.size());

        return getJdbcTemplate().query(query, beanDescription.rowMapper(), directoryIds);
    }
}
