package ru.yandex.calendar.logic.organization;


import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.Organization;


public class OrganizationManager {
    @Autowired
    private OrganizationDao organizationDao;

    public ListF<Organization> getOrCreateOrganizationsByDirectoryIds(ListF<Long> directoryIds) {
        ListF<Organization> createOrganizations = organizationDao.createOrganizationsByDirectoryIds(directoryIds);
        ListF<Long> newDirectoryIds = createOrganizations.map(Organization::getDirectoryId);
        ListF<Long> missingIds = directoryIds.filterNot(newDirectoryIds.containsF());

        return createOrganizations.plus(organizationDao.findOrganizationByDirectoryIds(missingIds));
    }
}
