package ru.yandex.calendar.logic.resource;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.OfficeFields;
import ru.yandex.calendar.util.db.SqlFunction;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author dbrylev
 */
public class OfficeFilter {
    private final Option<ListF<Long>> idFilter;
    private final Option<ListF<String>> abbrFilter;
    private final Option<ListF<String>> cityNameFilter;

    private OfficeFilter(
            Option<ListF<Long>> idFilter, Option<ListF<String>> abbrFilter, Option<ListF<String>> cityNameFilter)
    {
        this.idFilter = idFilter;
        this.abbrFilter = abbrFilter;
        this.cityNameFilter = cityNameFilter;
    }

    public static OfficeFilter any() {
        return new OfficeFilter(Option.<ListF<Long>>empty(), Option.<ListF<String>>empty(), Option.<ListF<String>>empty());
    }

    public static OfficeFilter byId(long officeId) {
        return new OfficeFilter(Option.of(Cf.list(officeId)), Option.<ListF<String>>empty(), Option.<ListF<String>>empty());
    }

    public OfficeFilter withId(ListF<Long> ids) {
        return new OfficeFilter(Option.of(ids), abbrFilter, cityNameFilter);
    }

    public OfficeFilter withAbbr(ListF<String> abbrs) {
        return new OfficeFilter(idFilter, Option.of(abbrs), cityNameFilter);
    }

    public OfficeFilter withCityName(ListF<String> cityNames) {
        return new OfficeFilter(idFilter, abbrFilter, Option.of(cityNames));
    }

    public SqlCondition getSqlCondition() {
        SqlCondition c = SqlCondition.trueCondition();

        if (idFilter.isPresent()) {
            c = c.and(OfficeFields.ID.column().inSet(idFilter.get()));
        }
        if (abbrFilter.isPresent()) {
            c = c.and(inLowerCase(OfficeFields.ABBR, abbrFilter.get()));
        }
        if (cityNameFilter.isPresent()) {
            c = c.and(inLowerCase(OfficeFields.CITY_NAME, cityNameFilter.get())
                    .or(inLowerCase(OfficeFields.CITY_NAME_EN, cityNameFilter.get())));
        }
        return c;
    }

    private static SqlCondition inLowerCase(MapField<String> field, ListF<String> values) {
        return SqlFunction.lower(field.column()).inSet(values.map(String::toLowerCase));
    }
}
