package ru.yandex.calendar.logic.resource;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.error.ReadableErrorMessageSource;
import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.calendar.frontend.web.cmd.run.Situation;
import ru.yandex.calendar.logic.user.NameI18n;

/**
 * @author dbrylev
 */
public class ResourceInaccessibleException extends CommandRunException implements ReadableErrorMessageSource {

    private final ResourceInaccessibility inaccessibility;

    public ResourceInaccessibleException(ResourceInaccessibility inaccessibility) {
        super(new String(ResourceInaccessibility.ps.getSerializer().serializeJson(inaccessibility)),
                null, Option.of(chooseSituation(inaccessibility)));
        this.inaccessibility = inaccessibility;
    }

    public ResourceInaccessibility getInaccessibility() {
        return inaccessibility;
    }

    @Override
    public NameI18n getReadableMessage() {
        return getInaccessibility().getReadableMessage();
    }

    private static Situation chooseSituation(ResourceInaccessibility inaccessibility) {
        ResourceType resourceType = inaccessibility.getResource().getType();

        switch (inaccessibility.getReason()) {
            case MASSAGE_DENIED: return Situation.MASSAGE_DENIED;
            case ZERO_LENGTH_EVENT:
            case TOO_SHORT_EVENT:
                return Situation.TOO_SHORT_EVENT;
            case TOO_LONG_EVENT: return Situation.TOO_LONG_EVENT;
            case REPETITION_DENIED: return resourceType == ResourceType.MASSAGE_ROOM
                    ? Situation.MASSAGE_DENIED
                    : Situation.PERMISSION_ERROR;
        }
        return Situation.PERMISSION_ERROR;
    }
}
