package ru.yandex.calendar.logic.resource;

import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.enums.OrdinalIntEnum;
import ru.yandex.misc.enums.OrdinalIntEnumResolver;

/**
 * @author dbrylev
 */
public enum ResourceType implements OrdinalIntEnum {
    ROOM(0, Days.ONE),
    PARKING(1, Days.ONE),
    APARTMENT(2, Days.days(365)),
    MASSAGE_ROOM(3, Days.ONE),
    PROTECTED_ROOM(4, Days.ONE), // CAL-6620
    YAMONEY_ROOM(5, Days.ONE), // CAL-7008
    CAMPUS(6, Days.days(365)),
    PRIVATE_ROOM(7, Days.ONE),
    HOTEL(8, Days.days(365)),
    ;

    public static final OrdinalIntEnumResolver<ResourceType> R = OrdinalIntEnumResolver.r(ResourceType.class);

    private static final SetF<ResourceType> VIEWABLE_WITHOUT_GROUPS = R.allOf().minus(Cf.set(APARTMENT, HOTEL));

    private static final SetF<ResourceType> BOOKABLE_WITHOUT_GROUPS = VIEWABLE_WITHOUT_GROUPS.minus1(PARKING);

    private static final SetF<ResourceType>
            YA_MONEY_BOOKABLE_WITHOUT_GROUPS = BOOKABLE_WITHOUT_GROUPS.minus1(MASSAGE_ROOM);

    private static final SetF<ResourceType> ORGANIZABLE_WITHOUT_GROUPS = BOOKABLE_WITHOUT_GROUPS.minus1(MASSAGE_ROOM);

    private final int value;
    private final Duration maxAllowedEventDuration;

    private ResourceType(int value, ReadablePeriod maxAllowedEventDuration) {
        this.value = value;
        this.maxAllowedEventDuration = maxAllowedEventDuration.toPeriod().toStandardDuration();
    }

    @Override
    public int value() {
        return value;
    }

    public Duration getMaxAllowedEventDuration() {
        return maxAllowedEventDuration;
    }

    public static SetF<ResourceType> viewableWithoutGroups() {
        return VIEWABLE_WITHOUT_GROUPS;
    }

    public static SetF<ResourceType> bookableWithoutGroups() {
        return BOOKABLE_WITHOUT_GROUPS;
    }

    public static SetF<ResourceType> yaMoneyBookableWithoutGroups() {
        return YA_MONEY_BOOKABLE_WITHOUT_GROUPS;
    }

    public static SetF<ResourceType> organizeableWithoutGroups() {
        return ORGANIZABLE_WITHOUT_GROUPS;
    }
}
