package ru.yandex.calendar.logic.resource;

import ru.yandex.bolts.function.forhuman.Comparator;

/**
 * @author Stepan Koltsov
 */
public class SubjectIdComparator {

    public static Comparator<UidOrResourceId> comparator() {
        Comparator<UidOrResourceId> c1 = UidOrResourceId.isUserF().asFunction().andThenNaturalComparator();

        Comparator<UidOrResourceId> c2 = new Comparator<UidOrResourceId>() {

            @Override
            public int compare(UidOrResourceId o1, UidOrResourceId o2) {
                if (o1.isUser() && o2.isUser()) {
                    return Comparator.<Long>naturalComparator().compare(o1.getUid().getUid(), o2.getUid().getUid());
                }
                if (o1.isResource() && o2.isResource()) {
                    return Comparator.<Long>naturalComparator().compare(o1.getResourceId(), o2.getResourceId());
                }
                throw new IllegalStateException("incorrect implementation of comparator");
            }
        };

        return c1.thenComparing(c2);
    }

} //~
