package ru.yandex.calendar.logic.resource.reservation;

import ru.yandex.bolts.collection.Either;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.ResourceReservation;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class EventOrReservationInterval {
    private final Either<Event, ResourceReservation> event;
    private final InstantInterval interval;

    public EventOrReservationInterval(
            Either<Event, ResourceReservation> event, InstantInterval interval)
    {
        this.event = event;
        this.interval = interval;
    }

    public InstantInterval getInterval() {
        return interval;
    }

    public Either<Event, ResourceReservation> getEventOrReservation() {
        return event.isLeft()
                ? Either.left(event.getLeft())
                : Either.right(event.getRight());
    }
}
