package ru.yandex.calendar.logic.resource.reservation;

import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.beans.generated.Rdate;
import ru.yandex.calendar.logic.beans.generated.Repetition;
import ru.yandex.calendar.logic.beans.generated.ResourceReservation;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.event.repetition.RepetitionUtils;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecur;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurParser;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class ResourceReservationInfo {
    private final ResourceReservation reservation;
    private final RepetitionInstanceInfo repetitionInfo;

    public ResourceReservationInfo(ResourceReservation reservation) {
        InstantInterval interval = new InstantInterval(reservation.getStartTs(), reservation.getEndTs());
        DateTimeZone tz = AuxDateTime.getVerifyDateTimeZone(reservation.getTimezoneId());

        RepetitionInstanceInfo repetitionInfo;

        if (reservation.getRRule().isPresent()) {
            IcsRecur recur = IcsRecurParser.P.parseRecur(reservation.getRRule().get());

            Repetition rep = RepetitionUtils.getRepetition(recur, interval.getStart(), tz);
            rep.setDueTs(reservation.getRDueTs().getOrNull());

            ListF<Rdate> exdates = recur.getXExclude().map(RepetitionUtils::consExdate);

            repetitionInfo = new RepetitionInstanceInfo(interval, tz, Option.of(rep), Cf.list(), exdates, Cf.list());

        } else {
            repetitionInfo = new RepetitionInstanceInfo(interval, tz, Option.empty(), Cf.list(), Cf.list(), Cf.list());
        }

        this.reservation = reservation;
        this.repetitionInfo = repetitionInfo;
    }

    public ResourceReservation getReservation() {
        return reservation;
    }

    public long getReservationId() {
        return reservation.getReservationId();
    }

    public long getResourceId() {
        return reservation.getResourceId();
    }

    public PassportUid getCreatorUid() {
        return reservation.getCreatorUid();
    }

    public RepetitionInstanceInfo getRepetitionInfo() {
        return repetitionInfo;
    }

    public ListF<InstantInterval> getInstanceIntervalsInInterval(InstantInterval interval) {
        return RepetitionUtils.getInstancesInInterval(repetitionInfo, interval);
    }

    public static Function1B<ResourceReservationInfo> hasZeroLengthF() {
        return rr -> rr.repetitionInfo.getEventInterval().isEmpty();
    }
}
