package ru.yandex.calendar.logic.resource.schedule;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.event.EventInstanceInfo;
import ru.yandex.calendar.logic.event.EventInterval;
import ru.yandex.calendar.logic.event.EventWithRelations;
import ru.yandex.misc.time.InstantInterval;

/**
* @author gutman
*/
public class EventIntervalInfo {
    private final EventInterval interval;
    private final EventWithRelations eventWithRelations;
    private final boolean mayView;

    public EventIntervalInfo(InstantInterval interval, EventWithRelations eventWithRelations, boolean mayView) {
        this.interval = eventWithRelations.getEventInterval(interval);
        this.eventWithRelations = eventWithRelations;
        this.mayView = mayView;
    }

    public static Function<EventInstanceInfo, EventIntervalInfo> fromEventInstanceInfoF() {
        return new Function<EventInstanceInfo, EventIntervalInfo>() {
            public EventIntervalInfo apply(EventInstanceInfo i) {
                return new EventIntervalInfo(i.getInterval(), i.getEventWithRelations(), i.getMayView());
            }
        };
    }

    public long getEventId() {
        return eventWithRelations.getEvent().getId();
    }

    public InstantInterval getInterval() {
        return interval.toInstantInterval(eventWithRelations.getTimezone());
    }

    public EventInterval getEventInterval() {
        return interval;
    }

    public boolean getMayView() {
        return mayView;
    }

    public EventWithRelations getEventWithRelations() {
        return eventWithRelations;
    }

    public static Function<EventIntervalInfo, InstantInterval> getIntervalF() {
        return new Function<EventIntervalInfo, InstantInterval>() {
            public InstantInterval apply(EventIntervalInfo i) {
                return i.getInterval();
            }
        };
    }

    public static Function<EventIntervalInfo, Long> getEventIdF() {
        return new Function<EventIntervalInfo, Long>() {
            public Long apply(EventIntervalInfo i) {
                return i.getEventId();
            }
        };
    }

}
