package ru.yandex.calendar.logic.resource.schedule;

import org.jdom.Element;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.frontend.web.cmd.run.ui.event.EventXmlizer;
import ru.yandex.calendar.frontend.web.cmd.run.ui.resource.ResourceXmlizer;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.resource.SpecialResources;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.UserInfo;
import ru.yandex.calendar.util.dates.DateInterval;
import ru.yandex.calendar.util.dates.DateOrDateTime;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author gutman
 * @author shinderuk
 */
public class EventScheduleInfoXmlizer {

    public Element xmlizeData(
            UserInfo userInfo, Tuple2<ResourceInfo, ResourceEventsAndReservations> data,
            InstantInterval scheduleInterval, DateTimeZone tz, Language lang,
            SetF<Long> currentUserEvents, MapF<PassportUid, String> loginByUid)
    {
        boolean canAdmin = userInfo.canAdminResource(data._1.getResource());

        boolean canBook = userInfo.canBookResource(data._1.getResource());

        Element element = new Element("resource-events");
        Element resource = ResourceXmlizer.toXml(data._1, lang);

        CalendarXmlizer.appendElm(resource, "can-book", canBook);
        CalendarXmlizer.appendElm(resource, "can-admin", canAdmin);
        element.addContent(resource);

        Element restrictions = CalendarXmlizer.appendElm(element, "restrictions");
        for (DateInterval restriction : getRestrictions(userInfo, data.get1(), scheduleInterval, tz)) {
            Element rs = CalendarXmlizer.appendElm(restrictions, "restriction");

            restriction.start.forEach(st -> CalendarXmlizer.setAttr(rs, "start-ts", st.toLocalDateTime()));
            restriction.end.forEach(en -> CalendarXmlizer.setAttr(rs, "end-ts", en.toLocalDateTime()));
            restriction.title.forEach(t -> CalendarXmlizer.setAttr(rs, "title", t.getName(lang)));
        }

        Element eventsElement = new Element("events");

        for (EventIdOrReservationInterval interval : data._2.getIntervals()) {
            Element eventElement = new Element("event");
            CalendarXmlizer.appendDtfElm(eventElement, EventXmlizer.START_TS_NAME, interval.getInterval().getStart(), tz);
            CalendarXmlizer.appendDtfElm(eventElement, EventXmlizer.END_TS_NAME, interval.getInterval().getEnd(), tz);

            CalendarXmlizer.appendDtfElm(eventElement, "instance-start-ts",
                    interval.getInterval().getStart(), DateTimeZone.UTC);

            if (interval.getEventId().isPresent()) {
                CalendarXmlizer.appendElm(eventElement, "id", interval.getEventId().get());
                boolean userIsParticipant = currentUserEvents.containsTs(interval.getEventId().get());
                CalendarXmlizer.appendElm(eventElement, "user-is-participant", userIsParticipant);
            } else {
                CalendarXmlizer.appendElm(eventElement, "reservation-id", interval.getReservationId().get());

                String creatorLogin = loginByUid.getOrElse(interval.getReservationCreatorUid().get(), "");
                CalendarXmlizer.appendElm(eventElement, "creator-login", creatorLogin);
            }
            eventsElement.addContent(eventElement);
        }

        element.addContent(eventsElement);

        return element;
    }

    private ListF<DateInterval> getRestrictions(
            UserInfo user, ResourceInfo resource, InstantInterval scheduleInterval, DateTimeZone tz)
    {
        Option<DateInterval> reachedDistance = SpecialResources.getEventMaxStart(user, resource, Instant.now())
                .map(dt -> new DateInterval(Option.of(DateOrDateTime.dateTime(
                        dt.toDateTime(tz).toLocalDateTime())), Option.empty()))
                .filter(d -> d.toInstantInterval(tz).overlaps(scheduleInterval));

        ListF<DateInterval> restrictions = SpecialResources.getRestrictionDates(resource)
                .filter(d -> d.toInstantInterval(tz).overlaps(scheduleInterval));

        return reachedDistance.plus(restrictions);
    }
}
