package ru.yandex.calendar.logic.resource.schedule;

import org.joda.time.LocalDate;

import ru.yandex.bolts.function.Function;

/**
 * @author dbrylev
 */
public class ResourceDaySchedule {
    private final LocalDate date;
    private final ResourceEventsAndReservations schedule;

    public ResourceDaySchedule(LocalDate date, ResourceEventsAndReservations schedule) {
        this.date = date;
        this.schedule = schedule;
    }

    public long getResourceId() {
        return schedule.getResourceId();
    }

    public LocalDate getDate() {
        return date;
    }

    public ResourceEventsAndReservations getSchedule() {
        return schedule;
    }

    public static Function<ResourceDaySchedule, Long> getResourceIdF() {
        return new Function<ResourceDaySchedule, Long>() {
            public Long apply(ResourceDaySchedule schedule) {
                return schedule.getResourceId();
            }
        };
    }

    public static Function<ResourceDaySchedule, LocalDate> getDateF() {
        return new Function<ResourceDaySchedule, LocalDate>() {
            public LocalDate apply(ResourceDaySchedule s) {
                return s.getDate();
            }
        };
    }
}
