package ru.yandex.calendar.logic.resource.schedule;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.beans.generated.ResourceReservation;
import ru.yandex.calendar.logic.suggest.IntervalSet;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class ResourceEventsAndReservations {
    private final long resourceId;
    private final ListF<EventIdOrReservationInterval> intervals;

    public ResourceEventsAndReservations(
            long resourceId, ListF<EventIdOrReservationInterval> intervals)
    {
        this.resourceId = resourceId;
        this.intervals = intervals;
    }

    public long getResourceId() {
        return resourceId;
    }

    public ListF<EventIdOrReservationInterval> getIntervals() {
        return intervals;
    }

    public ListF<InstantInterval> getInstantIntervals() {
        return intervals.map(EventIdOrReservationInterval::getInterval);
    }

    public Tuple2List<Long, InstantInterval> getEventIntervals() {
        return intervals.filter(e -> e.getEventId().isPresent())
                .toTuple2List(i -> i.getEventId().get(), EventIdOrReservationInterval::getInterval);
    }

    public ListF<Long> getEventIds() {
        return intervals.filterMap(EventIdOrReservationInterval::getEventId);
    }

    public ListF<ResourceReservation> getReservations() {
        return intervals.filterMap(EventIdOrReservationInterval::getReservation);
    }

    public ResourceEventsAndReservations filterIntervals(Function1B<EventIdOrReservationInterval> filter) {
        return new ResourceEventsAndReservations(resourceId, intervals.filter(filter));
    }

    public ListF<PassportUid> getReservationCreatorUids() {
        return intervals.filterMap(EventIdOrReservationInterval::getReservationCreatorUid);
    }

    public ListF<InstantInterval> getMergedIntervals() {
        return IntervalSet.cons(getInstantIntervals()).getIntervals();
    }
}
