package ru.yandex.calendar.logic.resource.schedule;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.calendar.logic.event.EventInstanceInfo;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.sharing.participant.Participants;

/**
 * @author gutman
 */
public class ResourceScheduleInfo {

    private final ResourceInfo resource;
    private final ListF<EventIntervalInfo> events;

    public ResourceScheduleInfo(ResourceInfo resource, ListF<EventIntervalInfo> events) {
        this.resource = resource;
        this.events = events;
    }

    public static Function2<ResourceInfo, Tuple2List<EventInstanceInfo, Participants>, ResourceScheduleInfo> consF() {
        return new Function2<ResourceInfo, Tuple2List<EventInstanceInfo, Participants>, ResourceScheduleInfo>() {
            public ResourceScheduleInfo apply(ResourceInfo r, Tuple2List<EventInstanceInfo, Participants> infos) {
                return new ResourceScheduleInfo(r, infos.get1().map(EventIntervalInfo.fromEventInstanceInfoF()));
            }
        };
    }


    ResourceInfo getResource() {
        return resource;
    }

    public ListF<EventIntervalInfo> getEvents() {
        return events;
    }

    public static Function<ResourceScheduleInfo, Long> getResourceIdF() {
        return new Function<ResourceScheduleInfo, Long>() {
            public Long apply(ResourceScheduleInfo r) {
                return r.resource.getResource().getId();
            }
        };
    }

    public static Function<ResourceScheduleInfo, Resource> getResourceF() {
        return new Function<ResourceScheduleInfo, Resource>() {
            public Resource apply(ResourceScheduleInfo r) {
                return r.resource.getResource();
            }
        };
    }

}
