package ru.yandex.calendar.logic.sending;

import org.joda.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.api.mail.MailEventChangesInfo;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.calendar.logic.beans.generated.Settings;
import ru.yandex.calendar.logic.event.ChangedEventInfoForMails;
import ru.yandex.calendar.logic.event.EventWithRelations;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.resource.ResourceType;
import ru.yandex.calendar.logic.resource.SpecialResources;
import ru.yandex.calendar.logic.sending.param.CancelEventMessageParameters;
import ru.yandex.calendar.logic.sending.param.CommonEventMessageParameters;
import ru.yandex.calendar.logic.sending.param.EventMessageChanged;
import ru.yandex.calendar.logic.sending.param.EventMessageInfo;
import ru.yandex.calendar.logic.sending.param.EventMessageInfoCreator;
import ru.yandex.calendar.logic.sending.param.EventMessageParameters;
import ru.yandex.calendar.logic.sending.param.EventOnResourceChangeMessageParameters;
import ru.yandex.calendar.logic.sending.param.InvitationMessageParameters;
import ru.yandex.calendar.logic.sending.param.MessageOverrides;
import ru.yandex.calendar.logic.sending.param.ReplyMessageParameters;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.calendar.logic.sharing.participant.ParticipantBasics;
import ru.yandex.calendar.logic.svc.SvcRoutines;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.inside.passport.blackbox.PassportAuthDomain;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.env.EnvironmentType;

public class EventInvitationOrCancelMessageXmlCreator {
    @Autowired
    private SvcRoutines svcRoutines;
    @Autowired
    private EventMessageInfoCreator eventMessageInfoCreator;
    @Autowired
    private SettingsRoutines settingsRoutines;
    @Autowired
    private EnvironmentType environmentType;

    public EventMessageParameters createXml(
            InvitationOrCancelEmailData invitationEmailData,
            EventWithRelations event,
            RepetitionInstanceInfo repetitionInstanceInfo,
            Option<Settings> recipientSettings)
    {
        Email emailFrom = svcRoutines.getCalendarInfoEmail(
                PassportAuthDomain.byEmail(invitationEmailData.getSender().getEmail()));

        Language language = settingsRoutines.chooseMailLanguageBySettings(
                invitationEmailData.getSender().getUid(), recipientSettings);

        String calendarUrl = recipientSettings
                .map(svcRoutines::getCalendarUrlBySettings)
                .getOrElse(() -> svcRoutines.getCalendarUrlForDomain(PassportAuthDomain.byUid(event.getEvent().getCreatorUid()), language));

        CommonEventMessageParameters commonMessageParameters = new CommonEventMessageParameters(
                language, new LocalDateTime(invitationEmailData.getTz()),
                invitationEmailData.getSender(), invitationEmailData.getRecipient(), emailFrom,
                calendarUrl, false, new MessageOverrides(invitationEmailData.getDestination()));

        Option<ParticipantBasics> organizerOverride = Option.empty();

        Option<EventMessageChanged> changes = invitationEmailData.getChangesInfo()
                .map(ChangedEventInfoForMails::getChanges).map(EventMessageChanged::new);

        if (invitationEmailData.getMeetingMailType() == MailType.EVENT_REORGANIZATION) {
            changes = Option.of(new EventMessageChanged(Cf.list(EventMessageChanged.Field.ORGANIZER)));
            organizerOverride = invitationEmailData.getChangesInfo().get().getChanges().getParticipantsChanges().getNewOrganizerParticipant();
        }

        EventMessageInfo eventMessageInfo = eventMessageInfoCreator.create(
                event, repetitionInstanceInfo, invitationEmailData.getEventInstance(),
                invitationEmailData.getRecipient().getEmail(), invitationEmailData.getRecipientUid(),
                invitationEmailData.getChangesInfo(), organizerOverride, invitationEmailData.getReorganizedEventId(),
                language, invitationEmailData.getTz());

        Option<IcsCalendar> ics = invitationEmailData.getIcs().map(
                ical -> ical.withXYandexMailType(invitationEmailData.getMeetingMailType().name().toLowerCase()));

        if (EnvironmentType.PRODUCTION != environmentType) {
            ics = ics.map(ical -> ical.withXYandexEnvironment(environmentType.getValue()));
        }

        boolean forOrganizerOrCreator = event.getOrganizerIfMeetingOrElseCreator().getUidO()
                .exists(invitationEmailData.getRecipientUid().containsF());

        Option<MailEventChangesInfo> infoForYaMail = Option.empty();

        /* disabled since breaks outlook ics handling
        if (ics.isDefined()
            && passportAuthDomainsHolder.containsYandexTeamRu()
            && invitationEmailData.getMeetingMailType() == MailType.EVENT_UPDATE
            && invitationEmailData.getChangesInfo().isDefined())
        {
            // CAL-7323
            infoForYaMail = Option.some(toMailEventChangesInfo(
                    invitationEmailData.getChangesInfo().get(),
                    event, repetitionInstanceInfo, language));
        }
        */

        if (invitationEmailData.getMeetingMailType().isResourceDecline()) {
            Resource resource = invitationEmailData.getSubscriptionResource().get().getResource();

            return new ReplyMessageParameters(
                    commonMessageParameters, eventMessageInfo,
                    Decision.NO, Option.empty(), ics, invitationEmailData.getMeetingMailType(),
                    Option.of(SpecialResources.getDisplaySettings(resource)), false);
        }

        if (invitationEmailData.getSubscriptionResource().isPresent()) {
            ResourceInfo resource = invitationEmailData.getSubscriptionResource().get();

            return new EventOnResourceChangeMessageParameters(
                    commonMessageParameters, eventMessageInfo,
                    resource.getNameI18n(language).getOrElse(resource.getExchangeName()),
                    invitationEmailData.getGuestsNames(),
                    changes, invitationEmailData.getMeetingMailType().forResource(ResourceType.ROOM));
        }

        if (invitationEmailData.getMeetingMailType().isCancel()) {
            return new CancelEventMessageParameters(
                    commonMessageParameters, eventMessageInfo, ics,
                    invitationEmailData.getMeetingMailType());
        } else {
            return new InvitationMessageParameters(
                    commonMessageParameters, eventMessageInfo, infoForYaMail,
                    invitationEmailData.getPrivateTokenO(), invitationEmailData.getGuestsNames(), changes,
                    invitationEmailData.getDecision(), forOrganizerOrCreator, invitationEmailData.getMeetingMailType(), ics);
        }
    }
}
