package ru.yandex.calendar.logic.sending;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.log.LogEvent;
import ru.yandex.calendar.logic.log.LogEventType;
import ru.yandex.calendar.logic.sending.param.ApartmentMessageParameters;
import ru.yandex.calendar.logic.sending.param.EventMessageParameters;
import ru.yandex.calendar.logic.sending.param.MessageDestination;
import ru.yandex.calendar.logic.sending.param.NotificationMessageParameters;
import ru.yandex.calendar.logic.sending.param.ReplyMessageParameters;
import ru.yandex.calendar.logic.sending.real.DestinedMessage;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.sharing.MailType;
import ru.yandex.misc.email.Email;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class EventMailLogEventJson extends LogEvent {
    private final String messageId;
    private final String to;
    private final String from;
    private final MailType mailType;
    private final Optional<Decision> decision;
    private final Optional<String> notForExchange;
    @JsonUnwrapped
    private final EventIdLogDataJson eventIdLogData;
    @JsonIgnore
    private final EventMessageParameters parameters;

    private final String status;
    private final Optional<String> response;

    public EventMailLogEventJson(
            EventMessageParameters parameters,
            Email to, DestinedMessage destined,
            String messageId, String status, Optional<String> response
    ) {
        this.parameters = parameters;
        this.to = to.getEmail();
        this.messageId = messageId;
        this.from = parameters.getSender().getEmail().getEmail();
        this.mailType = parameters.mailType();
        this.eventIdLogData = parameters.getEventIdLogDataJson();
        if (parameters instanceof ReplyMessageParameters) {
            decision = Optional.of(((ReplyMessageParameters) parameters).getDecision());
        } else {
            decision = Optional.empty();
        }
        if (destined.getDestination() == MessageDestination.NOT_FOR_EXCHANGE) {
            this.notForExchange = Optional.of("yes");
        } else {
            this.notForExchange = Optional.empty();
        }
        this.status = status;
        this.response = response;
    }

    @JsonGetter
    @Override
    public LogEventType type() {
        return LogEventType.EVENT_MAIL;
    }

    @Override
    public boolean isAccept(ActionInfo actionInfo) {
        return !(parameters instanceof NotificationMessageParameters)
                && !(parameters instanceof ApartmentMessageParameters);
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public Optional<EventIdLogDataJson> getEventId() {
        return Optional.of(eventIdLogData);
    }
}
