package ru.yandex.calendar.logic.sending;

import org.jdom.Element;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.event.repetition.RepetitionUtils;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author Stepan Koltsov
 */
public class EventMarkupXmlCreator {

    public Element createEventVerstkaXml(EventXmlCreationInfo info, DateTimeZone tz) {
        Instant closestEventInstanceStart = RepetitionUtils
                .getClosestInstanceInterval(info.getRepetitionInstanceInfo(), Instant.now()).map(InstantInterval::getStart)
                .getOrElse(info.getRepetitionInstanceInfo().getEventStart());

        Element res = new Element(EventXmlCreator.DEF_MAIN_TAG_NAME);

        CalendarXmlizer.appendElm(res, "event-id", info.event.getId());
        CalendarXmlizer.appendElm(res, "event-name", info.event.getName());
        CalendarXmlizer.appendElm(res, "event-start-ts", closestEventInstanceStart.toDateTime(tz).toLocalDateTime());

        if (info.getRepetitionInstanceInfo() != null && info.getRepetitionInstanceInfo().getRepetition().isPresent()) {
            info.getRepetitionInstanceInfo().getRepetition().get().addXmlElementTo(res, tz);
        }
        return res;
    }


    public static class EventXmlCreationInfo {
        private final Event event;
        private final RepetitionInstanceInfo repetitionInstanceInfo;

        public EventXmlCreationInfo(Event event, RepetitionInstanceInfo rii) {
            Validate.notNull(event);
            this.event = event;
            this.repetitionInstanceInfo = rii;
        }

        public Event getEvent() { return event; }
        public RepetitionInstanceInfo getRepetitionInstanceInfo() { return repetitionInstanceInfo; }
    }

} //~
